package com.crihexe.hiddenviewsmind.dto;

import com.crihexe.hiddenviewsmind.db.entities.PostEntity;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/**
 * DTO for {@link PostEntity}
 */
@Builder
@Getter
@Setter
public class Post {

    private Long id;

    private Long instagram_id;

    private PostType mediaType;     // only carousel, reels or stories
    private String imageURL;        // only images. required
    private String videoURL;        // only reels or videos. required
    private String caption;         // not on carousel children
    private Boolean carouselItem;   // only images and video. true for carousel children
    private List<Long> children = new ArrayList<>();          // only carousels. required
    private Set<UserTagImage> userTags = new LinkedHashSet<>(); // only images and videos
    private String audioName;       // only reels
    private Boolean shareToFeed;    // only reels
    private String locationID;      // not on carousel children
    private String coverURL;        // only reels
    private Integer thumbOffset;    // only reels or videos

    private Set<String> keywords = new LinkedHashSet<>();
    private LocalDateTime addedAt;
    private LocalDateTime postedAt;

}
